/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;

public class MagneticSpringPanel
extends JPanel
implements Runnable {
    final int m_nSleep = 20;
    final int m_nSleepNochange = 1000;
    final double m_dRate = 0.9;
    String m_methodHead = "MagneticSpring";
    String[] m_methodList = new String[]{"Spring", "Repulsion", "Magnet"};
    final int m_nNochangeEnd = 1;
    final boolean m_bCenterDraw = true;
    Vector m_node = null;
    Vector m_edge = null;
    Vector m_vmethod;
    int m_crossCount = 0;
    int m_calcCount = 0;
    Node m_checkNode = null;
    MouseListener mouseListener = new MouseAdapter(){

        public synchronized void mousePressed(MouseEvent mouseEvent) {
            if (MagneticSpringPanel.this.m_node != null) {
                int n = MagneticSpringPanel.this.getXInit();
                int n2 = MagneticSpringPanel.this.getYInit();
                int n3 = MagneticSpringPanel.this.m_node.size() - 1;
                while (n3 >= 0) {
                    Node node = (Node)MagneticSpringPanel.this.m_node.get(n3);
                    if (DrawTool.drawStringTest(MagneticSpringPanel.this.getGraphics(), node.m_name, node.m_x + n, node.m_y + n2, true, mouseEvent.getX(), mouseEvent.getY())) {
                        node.setFixed(true);
                        MagneticSpringPanel.this.m_checkNode = node;
                        MagneticSpringPanel.this.addMouseMotionListener(MagneticSpringPanel.this.mouseMotionListener);
                        break;
                    }
                    --n3;
                }
            }
        }

        public synchronized void mouseReleased(MouseEvent mouseEvent) {
            if (MagneticSpringPanel.this.m_checkNode != null) {
                MagneticSpringPanel.this.m_checkNode.setFixed(false);
                MagneticSpringPanel.this.m_checkNode = null;
                MagneticSpringPanel.this.removeMouseMotionListener(MagneticSpringPanel.this.mouseMotionListener);
            }
        }
    };
    MouseMotionListener mouseMotionListener = new MouseMotionAdapter(){

        public synchronized void mouseDragged(MouseEvent mouseEvent) {
            if (MagneticSpringPanel.this.m_checkNode != null) {
                MagneticSpringPanel.this.m_checkNode.m_x = mouseEvent.getX() - MagneticSpringPanel.this.getXInit();
                MagneticSpringPanel.this.m_checkNode.m_y = mouseEvent.getY() - MagneticSpringPanel.this.getYInit();
                MagneticSpringPanel.this.repaint();
            }
        }
    };
    Thread m_threadme = null;
    final int MODE_CALC = 0;
    final int MODE_WAIT = 1;
    int m_nMode = 0;

    MagneticSpringPanel() {
        this.addMouseListener(this.mouseListener);
        this.m_vmethod = new Vector();
        try {
            Class[] classArray = new Class[]{Class.forName("java.util.Vector"), Class.forName("java.util.Vector")};
            int n = 0;
            while (n < this.m_methodList.length) {
                try {
                    Class<?> clazz = Class.forName(this.m_methodHead + this.m_methodList[n]);
                    ForceMethod forceMethod = new ForceMethod(clazz.getMethod("force", classArray), this.m_methodList[n]);
                    this.m_vmethod.add(forceMethod);
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            return;
        }
    }

    Vector getForceMethod() {
        return this.m_vmethod;
    }

    void clear() {
        this.m_node = null;
        this.m_edge = null;
        this.m_threadme = null;
        this.m_nMode = 0;
    }

    boolean setData(Vector vector, Vector vector2, int n) {
        this.m_node = new Vector(vector);
        this.m_edge = new Vector(vector2);
        MagneticSpringInitialize.init(this.m_node, this.m_edge, this.getEffectSize(), n);
        return true;
    }

    boolean setData(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        return this.setData(defaultMutableTreeNode, n, 1);
    }

    boolean setData(DefaultMutableTreeNode defaultMutableTreeNode, int n, int n2) {
        if (this.m_node == null) {
            this.m_node = new Vector();
        }
        if (this.m_edge == null) {
            this.m_edge = new Vector();
        }
        this.setDataIn(defaultMutableTreeNode, n);
        MagneticSpringInitialize.init(this.m_node, this.m_edge, this.getEffectSize(), n2);
        return true;
    }

    boolean setDataIn(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        Object object;
        Node node = new Node((String)defaultMutableTreeNode.getUserObject());
        this.m_node.add(node);
        int n2 = this.m_node.size() - 1;
        if (n != -1) {
            object = new Edge(n, n2);
            this.m_edge.add(object);
        }
        object = defaultMutableTreeNode.children();
        while (object.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)object.nextElement();
            if (this.setDataIn(defaultMutableTreeNode2, n2)) continue;
            return false;
        }
        return true;
    }

    Dimension getEffectSize() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = new Dimension((int)(0.9 * (double)dimension.width), (int)(0.9 * (double)dimension.height));
        return dimension2;
    }

    int getXInit() {
        return (int)(0.09999999999999998 * (double)this.getSize().width / 2.0);
    }

    int getYInit() {
        return (int)(0.09999999999999998 * (double)this.getSize().height / 2.0);
    }

    public void paint(Graphics graphics) {
        Node node;
        Object object;
        int n = this.getXInit();
        int n2 = this.getYInit();
        Color color = graphics.getColor();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        graphics.setColor(color);
        if (this.m_node == null) {
            graphics.drawString("There is no data.", 10, 10);
            return;
        }
        Enumeration enumeration = this.m_edge.elements();
        while (enumeration.hasMoreElements()) {
            object = (Edge)enumeration.nextElement();
            node = ((Edge)object).getNodeFrom(this.m_node);
            Node node2 = ((Edge)object).getNodeTo(this.m_node);
            if (((Edge)object).m_cross != 0) {
                graphics.setColor(Color.red);
            } else {
                graphics.setColor(Color.black);
            }
            graphics.drawLine(node.m_x + n, node.m_y + n2, node2.m_x + n, node2.m_y + n2);
        }
        graphics.setColor(Color.black);
        object = this.m_node.elements();
        while (object.hasMoreElements()) {
            node = (Node)object.nextElement();
            DrawTool.drawString(graphics, node.m_name, node.m_x + n, node.m_y + n2, true);
        }
        if (this.m_nMode == 1) {
            graphics.drawString("End calc !!", 10, 20);
        }
        graphics.drawString("Cross line count = " + this.m_crossCount, 10, 35);
        graphics.drawString("Calc count = " + this.m_calcCount, 10, 55);
    }

    void relax() {
        this.m_threadme = new Thread(this);
        this.m_threadme.start();
    }

    void relaxstop() {
        this.m_threadme = null;
    }

    public void run() {
        Thread thread = Thread.currentThread();
        this.m_calcCount = 0;
        int n = 0;
        while (thread == this.m_threadme) {
            Object object;
            Object object2;
            Enumeration enumeration = this.m_vmethod.elements();
            while (enumeration.hasMoreElements()) {
                ForceMethod forceMethod = (ForceMethod)enumeration.nextElement();
                if (!forceMethod.getAvailable()) continue;
                try {
                    Object[] objectArray = new Object[]{this.m_node, this.m_edge};
                    forceMethod.m_method.invoke(null, objectArray);
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
            double d = 0.0;
            double d2 = 0.0;
            Enumeration enumeration2 = this.m_node.elements();
            while (enumeration2.hasMoreElements()) {
                object2 = (Node)enumeration2.nextElement();
                ((Node)object2).setBackXY();
                if (((Node)object2).m_dx > 0.0) {
                    ((Node)object2).m_dx += 0.5;
                } else if (((Node)object2).m_dx < 0.0) {
                    ((Node)object2).m_dx -= 0.5;
                }
                if (((Node)object2).m_y > 0) {
                    ((Node)object2).m_dy += 0.5;
                } else if (((Node)object2).m_dy < 0.0) {
                    ((Node)object2).m_dy -= 0.5;
                }
                ((Node)object2).m_x += (int)((Node)object2).m_dx;
                ((Node)object2).m_y += (int)((Node)object2).m_dy;
                ((Node)object2).m_dx = 0.0;
                ((Node)object2).m_dy = 0.0;
                d += (double)((Node)object2).m_x;
                d2 += (double)((Node)object2).m_y;
            }
            object2 = this.getEffectSize();
            double d3 = d / (double)this.m_node.size() - (double)((Dimension)object2).width / 2.0;
            double d4 = d2 / (double)this.m_node.size() - (double)((Dimension)object2).height / 2.0;
            boolean bl = true;
            Enumeration enumeration3 = this.m_node.elements();
            while (enumeration3.hasMoreElements()) {
                object = (Node)enumeration3.nextElement();
                ((Node)object).m_x = (int)((double)((Node)object).m_x - d3);
                ((Node)object).m_y = (int)((double)((Node)object).m_y - d4);
                if (((Node)object).m_x > ((Dimension)object2).width) {
                    ((Node)object).m_x = ((Dimension)object2).width;
                } else if (((Node)object).m_x < 0) {
                    ((Node)object).m_x = 0;
                }
                if (((Node)object).m_y > ((Dimension)object2).height) {
                    ((Node)object).m_y = ((Dimension)object2).height;
                } else if (((Node)object).m_y < 0) {
                    ((Node)object).m_y = 0;
                }
                if (((Node)object).checkBackXY()) continue;
                bl = false;
            }
            if (bl && this.m_nMode == 0) {
                if (n + 1 > 1) {
                    this.m_nMode = 1;
                } else {
                    ++n;
                }
            } else if (!bl && this.m_nMode == 1) {
                this.m_nMode = 0;
                n = 0;
            }
            this.m_crossCount = 0;
            object = this.m_edge.elements();
            while (object.hasMoreElements()) {
                Edge edge = (Edge)object.nextElement();
                edge.m_cross = 0;
            }
            int n2 = 0;
            while (n2 < this.m_edge.size() - 1) {
                try {
                    Edge edge = (Edge)this.m_edge.get(n2);
                    Node node = (Node)this.m_node.get(edge.m_from);
                    Node node2 = (Node)this.m_node.get(edge.m_to);
                    int n3 = node.m_x;
                    int n4 = node.m_y;
                    int n5 = node2.m_x;
                    int n6 = node2.m_y;
                    int n7 = n2 + 1;
                    while (n7 < this.m_edge.size()) {
                        double d5;
                        double d6;
                        double d7;
                        double d8;
                        Edge edge2 = (Edge)this.m_edge.get(n7);
                        Node node3 = (Node)this.m_node.get(edge2.m_from);
                        Node node4 = (Node)this.m_node.get(edge2.m_to);
                        int n8 = node3.m_x;
                        int n9 = node3.m_y;
                        int n10 = node4.m_x;
                        int n11 = node4.m_y;
                        if (!(n3 - n5 == 0 && n8 - n10 == 0 || n3 == n8 && n4 == n9 || n3 == n10 && n4 == n11 || n5 == n8 && n6 == n9 || n5 == n10 && n6 == n11 || n8 == n10 && n9 == n11 || (d8 = (double)((n8 - n10) * (n4 - n6) - (n3 - n5) * (n9 - n11))) == 0.0 || !((d7 = (d6 = (double)((n9 - n4) * (n3 - n5) * (n8 - n10) + (n8 - n10) * (n4 - n6) * n3 - (n3 - n5) * (n9 - n11) * n8)) / d8) <= (double)Math.max(n3, n5)) || !(d7 >= (double)Math.min(n3, n5)) || !(d7 <= (double)Math.max(n8, n10)) || !(d7 >= (double)Math.min(n8, n10)) || !((d5 = n3 - n5 != 0 ? (double)(n4 - n6) * d7 / (double)(n3 - n5) + (double)n4 - (double)((n4 - n6) * n3 / (n3 - n5)) : (double)(n9 - n11) * d7 / (double)(n8 - n10) + (double)n9 - (double)((n9 - n11) * n8 / (n8 - n10))) <= (double)Math.max(n4, n6)) || !(d5 >= (double)Math.min(n4, n6)) || !(d5 <= (double)Math.max(n9, n11)) || !(d5 >= (double)Math.min(n9, n11)))) {
                            ++edge.m_cross;
                            ++edge2.m_cross;
                            ++this.m_crossCount;
                        }
                        ++n7;
                    }
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
                ++n2;
            }
            ++this.m_calcCount;
            this.repaint();
            try {
                if (this.m_nMode == 0) {
                    Thread.sleep(20L);
                    continue;
                }
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println(interruptedException);
                break;
            }
        }
    }
}

