/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Vector;

class DrawTool {
    static FontMetrics fmetrics = null;

    DrawTool() {
    }

    static boolean drawStringTest(Graphics graphics, String string, int n, int n2, boolean bl, int n3, int n4) {
        DrawData drawData = new DrawData(graphics, string, n, n2, bl);
        return n3 >= drawData.xPosition && n3 <= drawData.xPosition + drawData.nPanelWidth + drawData.nFrameSize * 2 && n4 >= drawData.yPosition && n4 <= drawData.yPosition + drawData.nPanelHeight + drawData.nFrameSize * 2;
    }

    static void drawString(Graphics graphics, String string, int n, int n2, boolean bl) {
        DrawData drawData = new DrawData(graphics, string, n, n2, bl);
        Color color = graphics.getColor();
        graphics.setColor(drawData.frameColor);
        graphics.fillRect(drawData.xPosition, drawData.yPosition, drawData.nPanelWidth + drawData.nFrameSize * 2, drawData.nPanelHeight + drawData.nFrameSize * 2);
        graphics.setColor(drawData.innerColor);
        graphics.fillRect(drawData.nFrameSize + drawData.xPosition, drawData.nFrameSize + drawData.yPosition, drawData.nPanelWidth, drawData.nPanelHeight);
        graphics.setColor(color);
        int n3 = 0;
        while (n3 < drawData.stringList.size()) {
            String string2 = (String)drawData.stringList.get(n3);
            graphics.drawString(string2, drawData.xPosition + drawData.xBlank + drawData.nFrameSize, drawData.yPosition + drawData.yBlank + drawData.yInterval * (n3 + 1));
            ++n3;
        }
    }

    static class DrawData {
        int xBlank = 2;
        int yBlank = 2;
        int nFrameSize = 2;
        int xPosition;
        int yPosition;
        int nPanelWidth;
        int nPanelHeight;
        int yInterval;
        Color frameColor = Color.black;
        Color innerColor = Color.white;
        Vector stringList;

        DrawData(Graphics graphics, String string, int n, int n2, boolean bl) {
            int n3;
            if (fmetrics == null) {
                fmetrics = graphics.getFontMetrics();
            }
            this.xPosition = n;
            this.yPosition = n2;
            this.yInterval = fmetrics.getHeight();
            this.nPanelWidth = 0;
            this.nPanelHeight = 0;
            this.stringList = new Vector();
            String string2 = new String(string);
            do {
                String string3;
                if ((n3 = string2.indexOf(10)) == -1) {
                    string3 = new String(string2);
                } else {
                    string3 = string2.substring(0, n3);
                    string2 = string2.substring(n3 + 1, string2.length());
                }
                int n4 = fmetrics.stringWidth(string3);
                this.nPanelWidth = this.nPanelWidth < n4 ? n4 : this.nPanelWidth;
                this.stringList.add(string3);
            } while (n3 != -1);
            this.nPanelWidth += this.xBlank * 2;
            this.nPanelHeight = this.yInterval * this.stringList.size() + this.yBlank * 2;
            if (bl) {
                this.xPosition -= (this.nPanelWidth + this.nFrameSize * 2) / 2;
                this.yPosition -= (this.nPanelHeight + this.nFrameSize * 2) / 2;
            }
        }
    }
}

