/*
 * Decompiled with CFR 0.152.
 */
class CVector {
    double m_x;
    double m_y;

    CVector() {
    }

    void setValue(double d, double d2) {
        this.m_x = d;
        this.m_y = d2;
    }

    CVector(double d, double d2) {
        this.m_x = d;
        this.m_y = d2;
    }

    CVector(CVector cVector) {
        this.m_x = cVector.m_x;
        this.m_y = cVector.m_y;
    }

    void init() {
        this.m_y = 0.0;
        this.m_x = 0.0;
    }

    boolean isInit() {
        return this.m_x == 0.0 && this.m_y == 0.0;
    }

    CVector plus(CVector cVector) {
        this.m_x += cVector.m_x;
        this.m_y += cVector.m_y;
        return this;
    }

    CVector rotate(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        return new CVector(this.m_x * d2 - this.m_y * d3, this.m_x * d3 + this.m_y * d2);
    }

    double getLength() {
        return Math.sqrt(Math.pow(this.m_x, 2.0) + Math.pow(this.m_y, 2.0));
    }

    double getRad() {
        if (this.m_y == 0.0) {
            if (this.m_x >= 0.0) {
                return 0.0;
            }
            return Math.PI;
        }
        if (this.m_x == 0.0) {
            if (this.m_y >= 0.0) {
                return 1.5707963267948966;
            }
            return 4.71238898038469;
        }
        double d = Math.acos(this.m_x / Math.sqrt(Math.pow(this.m_x, 2.0) + Math.pow(this.m_y, 2.0)));
        if (this.m_y < 0.0) {
            d = Math.PI * 2 - d;
        }
        return d;
    }

    int towordPlusMinus(CVector cVector) {
        if (this.m_x == 0.0 && this.m_y == 0.0 || cVector.m_x == 0.0 && cVector.m_y == 0.0) {
            return 0;
        }
        int n = this.diffWorld(cVector);
        switch (n) {
            case 0: 
            case 2: {
                double d = cVector.m_y / cVector.m_x - this.m_y / this.m_x;
                if (d == 0.0) {
                    return 0;
                }
                if (n == 0) {
                    return d > 0.0 ? 1 : -1;
                }
                return d > 0.0 ? -1 : 1;
            }
            case -1: {
                return -1;
            }
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    int diffWorld(CVector cVector) {
        int n;
        int n2 = this.getWorld();
        if (n2 == (n = cVector.getWorld())) {
            return 0;
        }
        if (Math.abs(n2 - n) == 2) {
            return 2;
        }
        if (Math.max(n2, n) - Math.min(n2, n) == 1) {
            return 1;
        }
        return -1;
    }

    int getWorld() {
        if (this.m_x > 0.0 && this.m_y >= 0.0) {
            return 1;
        }
        if (this.m_x <= 0.0 && this.m_y > 0.0) {
            return 2;
        }
        if (this.m_x < 0.0 && this.m_y <= 0.0) {
            return 3;
        }
        if (this.m_x >= 0.0 && this.m_y < 0.0) {
            return 4;
        }
        return 0;
    }

    public static double radToDeg(double d) {
        return d * 180.0 / Math.PI;
    }

    public static double degToRad(double d) {
        return d * Math.PI / 180.0;
    }
}

